import math

'''
Define classes for all the possible functions according to the following template:
class function:
    Initializer
    eval : takes in a point x and returns numerical value of the function at that point
    der : returns a function: the derivative of the current function
'''

class Add:
    def __init__(self, t1, t2):
        self.t1 = t1
        self.t2 = t2
    
    def eval(self, x):
        return self.t1.eval(x) + self.t2.eval(x)
    
    def der(self):
        return Add(self.t1.der(), self.t2.der())
    
class Mul:
    def __init__(self, t1, t2):
        self.t1 = t1
        self.t2 = t2
    
    def eval(self, x):
        return self.t1.eval(x) * self.t2.eval(x)

    def der(self):
        return Add(Mul(self.t1.der(), self.t2), Mul(self.t1, self.t2.der()))

class Exp:
    def __init__(self, t):
        self.t = t
    
    def eval(self, x):
        return math.exp(self.t.eval(x))

    def der(self):
        return Mul(self.t.der(), self)

class Pow:
    def __init__(self, t, n):
        self.t = t
        self.n = n

    def eval(self, x):
        return self.t.eval(x)**self.n.eval(x)
    
    def der(self):
        n = self.n.eval(0)
        if n == 0: return Const(0)
        return Mul(self.n, Mul(self.t.der(), Pow(self.t, Const(n - 1))))

class Sub:
    def __init__(self, a, b):
        self.a = a
        self.b = b

    def eval(self, x):
        return self.a.eval(x) - self.b.eval(x)

    def der(self):
        return Sub(self.a.der(), self.b.der())

class Div:
    def __init__(self, p, q):
        self.p = p
        self.q = q

    def eval(self, x):
        return self.p.eval(x)/self.q.eval(x)

    def der(self):
        return Div(Sub(Mul(self.q, self.p.der()), Mul(self.q.der(), self.p)),Pow(self.q, Const(2)))

class Const:
    def __init__(self, c):
        self.c = c

    def eval(self, x):
        return self.c
    
    def der(self):
        return Const(0)

class X:
    def __init__(self):
        pass
    
    def eval(self, x):
        return x

    def der(self):
        return Const(1)



# Take input and construct computation graph
functions = []

def resolve(text):
    if text.isdigit():
        return functions[int(text) - 1]
    if text[0] == 'x':
        return X()
    if text[0] == 'c':
        return Const(float(text[1:]))
    
no_nodes = int(input())
for i in range(no_nodes):
    text = input().split()
    if text[0] == 'exp':
        functions.append(Exp(resolve(text[1])))
    elif text[0] == 'add':
        functions.append(Add(resolve(text[1]), resolve(text[2])))
    elif text[0] == 'mul':
        functions.append(Mul(resolve(text[1]), resolve(text[2])))
    elif text[0] == 'div':
        functions.append(Div(resolve(text[1]), resolve(text[2])))
    elif text[0] == 'pow':
        functions.append(Pow(resolve(text[1]), resolve(text[2])))

p = float(input())

print(functions[-1].der().eval(p))

